#include "f2c.h"

/* Subroutine */ int clarfb_(char *side, char *trans, char *direct, char *
	storev, integer *m, integer *n, integer *k, complex *v, integer *ldv, 
	complex *t, integer *ldt, complex *c, integer *ldc, complex *work, 
	integer *ldwork)
{
/*  -- LAPACK auxiliary routine (version 2.0) --   
       Univ. of Tennessee, Univ. of California Berkeley, NAG Ltd.,   
       Courant Institute, Argonne National Lab, and Rice University   
       September 30, 1994   


    Purpose   
    =======   

    CLARFB applies a complex block reflector H or its transpose H' to a   
    complex M-by-N matrix C, from either the left or the right.   

    Arguments   
    =========   

    SIDE    (input) CHARACTER*1   
            = 'L': apply H or H' from the Left   
            = 'R': apply H or H' from the Right   

    TRANS   (input) CHARACTER*1   
            = 'N': apply H (No transpose)   
            = 'C': apply H' (Conjugate transpose)   

    DIRECT  (input) CHARACTER*1   
            Indicates how H is formed from a product of elementary   
            reflectors   
            = 'F': H = H(1) H(2) . . . H(k) (Forward)   
            = 'B': H = H(k) . . . H(2) H(1) (Backward)   

    STOREV  (input) CHARACTER*1   
            Indicates how the vectors which define the elementary   
            reflectors are stored:   
            = 'C': Columnwise   
            = 'R': Rowwise   

    M       (input) INTEGER   
            The number of rows of the matrix C.   

    N       (input) INTEGER   
            The number of columns of the matrix C.   

    K       (input) INTEGER   
            The order of the matrix T (= the number of elementary   
            reflectors whose product defines the block reflector).   

    V       (input) COMPLEX array, dimension   
                                  (LDV,K) if STOREV = 'C'   
                                  (LDV,M) if STOREV = 'R' and SIDE = 'L' 
  
                                  (LDV,N) if STOREV = 'R' and SIDE = 'R' 
  
            The matrix V. See further details.   

    LDV     (input) INTEGER   
            The leading dimension of the array V.   
            If STOREV = 'C' and SIDE = 'L', LDV >= max(1,M);   
            if STOREV = 'C' and SIDE = 'R', LDV >= max(1,N);   
            if STOREV = 'R', LDV >= K.   

    T       (input) COMPLEX array, dimension (LDT,K)   
            The triangular K-by-K matrix T in the representation of the   
            block reflector.   

    LDT     (input) INTEGER   
            The leading dimension of the array T. LDT >= K.   

    C       (input/output) COMPLEX array, dimension (LDC,N)   
            On entry, the M-by-N matrix C.   
            On exit, C is overwritten by H*C or H'*C or C*H or C*H'.   

    LDC     (input) INTEGER   
            The leading dimension of the array C. LDC >= max(1,M).   

    WORK    (workspace) COMPLEX array, dimension (LDWORK,K)   

    LDWORK  (input) INTEGER   
            The leading dimension of the array WORK.   
            If SIDE = 'L', LDWORK >= max(1,N);   
            if SIDE = 'R', LDWORK >= max(1,M).   

    ===================================================================== 
  


       Quick return if possible   

    
   Parameter adjustments   
       Function Body */
    /* Table of constant values */
    static complex c_b1 = {1.f,0.f};
    static integer c__1 = 1;
    
    /* System generated locals */
    integer c_dim1, c_offset, t_dim1, t_offset, v_dim1, v_offset, work_dim1, 
	    work_offset, i__1, i__2, i__3, i__4, i__5;
    complex q__1, q__2;
    /* Builtin functions */
    void r_cnjg(complex *, complex *);
    /* Local variables */
    static integer i, j;
    extern /* Subroutine */ int cgemm_(char *, char *, integer *, integer *, 
	    integer *, complex *, complex *, integer *, complex *, integer *, 
	    complex *, complex *, integer *);
    extern logical lsame_(char *, char *);
    extern /* Subroutine */ int ccopy_(integer *, complex *, integer *, 
	    complex *, integer *), ctrmm_(char *, char *, char *, char *, 
	    integer *, integer *, complex *, complex *, integer *, complex *, 
	    integer *), clacgv_(integer *, 
	    complex *, integer *);
    static char transt[1];




#define V(I,J) v[(I)-1 + ((J)-1)* ( *ldv)]
#define T(I,J) t[(I)-1 + ((J)-1)* ( *ldt)]
#define C(I,J) c[(I)-1 + ((J)-1)* ( *ldc)]
#define WORK(I,J) work[(I)-1 + ((J)-1)* ( *ldwork)]

    if (*m <= 0 || *n <= 0) {
	return 0;
    }

    if (lsame_(trans, "N")) {
	*(unsigned char *)transt = 'C';
    } else {
	*(unsigned char *)transt = 'N';
    }

    if (lsame_(storev, "C")) {

	if (lsame_(direct, "F")) {

/*           Let  V =  ( V1 )    (first K rows)   
                       ( V2 )   
             where  V1  is unit lower triangular. */

	    if (lsame_(side, "L")) {

/*              Form  H * C  or  H' * C  where  C = ( C1 )   
                                                    ( C2 )   

                W := C' * V  =  (C1'*V1 + C2'*V2)  (stored in 
WORK)   

                W := C1' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(n, &C(j,1), ldc, &WORK(1,j), &
			    c__1);
		    clacgv_(n, &WORK(1,j), &c__1);
/* L10: */
		}

/*              W := W * V1 */

		ctrmm_("Right", "Lower", "No transpose", "Unit", n, k, &c_b1, 
			&V(1,1), ldv, &WORK(1,1), ldwork);
		if (*m > *k) {

/*                 W := W + C2'*V2 */

		    i__1 = *m - *k;
		    cgemm_("Conjugate transpose", "No transpose", n, k, &i__1,
			     &c_b1, &C(*k+1,1), ldc, &V(*k+1,1), ldv, &c_b1, &WORK(1,1), ldwork);
		}

/*              W := W * T'  or  W * T */

		ctrmm_("Right", "Upper", transt, "Non-unit", n, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - V * W' */

		if (*m > *k) {

/*                 C2 := C2 - V2 * W' */

		    i__1 = *m - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("No transpose", "Conjugate transpose", &i__1, n, k,
			     &q__1, &V(*k+1,1), ldv, &WORK(1,1), ldwork, &c_b1, &C(*k+1,1), 
			    ldc);
		}

/*              W := W * V1' */

		ctrmm_("Right", "Lower", "Conjugate transpose", "Unit", n, k, 
			&c_b1, &V(1,1), ldv, &WORK(1,1), ldwork);

/*              C1 := C1 - W' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *n;
		    for (i = 1; i <= *n; ++i) {
			i__3 = j + i * c_dim1;
			i__4 = j + i * c_dim1;
			r_cnjg(&q__2, &WORK(i,j));
			q__1.r = C(j,i).r - q__2.r, q__1.i = C(j,i).i - 
				q__2.i;
			C(j,i).r = q__1.r, C(j,i).i = q__1.i;
/* L20: */
		    }
/* L30: */
		}

	    } else if (lsame_(side, "R")) {

/*              Form  C * H  or  C * H'  where  C = ( C1  C2 )
   

                W := C * V  =  (C1*V1 + C2*V2)  (stored in WOR
K)   

                W := C1 */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(m, &C(1,j), &c__1, &WORK(1,j), &c__1);
/* L40: */
		}

/*              W := W * V1 */

		ctrmm_("Right", "Lower", "No transpose", "Unit", m, k, &c_b1, 
			&V(1,1), ldv, &WORK(1,1), ldwork);
		if (*n > *k) {

/*                 W := W + C2 * V2 */

		    i__1 = *n - *k;
		    cgemm_("No transpose", "No transpose", m, k, &i__1, &c_b1,
			     &C(1,*k+1), ldc, &V(*k+1,1), ldv, &c_b1, &WORK(1,1), ldwork);
		}

/*              W := W * T  or  W * T' */

		ctrmm_("Right", "Upper", trans, "Non-unit", m, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - W * V' */

		if (*n > *k) {

/*                 C2 := C2 - W * V2' */

		    i__1 = *n - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("No transpose", "Conjugate transpose", m, &i__1, k,
			     &q__1, &WORK(1,1), ldwork, &V(*k+1,1), ldv, &c_b1, &C(1,*k+1), 
			    ldc);
		}

/*              W := W * V1' */

		ctrmm_("Right", "Lower", "Conjugate transpose", "Unit", m, k, 
			&c_b1, &V(1,1), ldv, &WORK(1,1), ldwork);

/*              C1 := C1 - W */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *m;
		    for (i = 1; i <= *m; ++i) {
			i__3 = i + j * c_dim1;
			i__4 = i + j * c_dim1;
			i__5 = i + j * work_dim1;
			q__1.r = C(i,j).r - WORK(i,j).r, q__1.i = C(i,j).i 
				- WORK(i,j).i;
			C(i,j).r = q__1.r, C(i,j).i = q__1.i;
/* L50: */
		    }
/* L60: */
		}
	    }

	} else {

/*           Let  V =  ( V1 )   
                       ( V2 )    (last K rows)   
             where  V2  is unit upper triangular. */

	    if (lsame_(side, "L")) {

/*              Form  H * C  or  H' * C  where  C = ( C1 )   
                                                    ( C2 )   

                W := C' * V  =  (C1'*V1 + C2'*V2)  (stored in 
WORK)   

                W := C2' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(n, &C(*m-*k+j,1), ldc, &WORK(1,j), &c__1);
		    clacgv_(n, &WORK(1,j), &c__1);
/* L70: */
		}

/*              W := W * V2 */

		ctrmm_("Right", "Upper", "No transpose", "Unit", n, k, &c_b1, 
			&V(*m-*k+1,1), ldv, &WORK(1,1), 
			ldwork);
		if (*m > *k) {

/*                 W := W + C1'*V1 */

		    i__1 = *m - *k;
		    cgemm_("Conjugate transpose", "No transpose", n, k, &i__1,
			     &c_b1, &C(1,1), ldc, &V(1,1), ldv, &
			    c_b1, &WORK(1,1), ldwork);
		}

/*              W := W * T'  or  W * T */

		ctrmm_("Right", "Lower", transt, "Non-unit", n, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - V * W' */

		if (*m > *k) {

/*                 C1 := C1 - V1 * W' */

		    i__1 = *m - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("No transpose", "Conjugate transpose", &i__1, n, k,
			     &q__1, &V(1,1), ldv, &WORK(1,1), 
			    ldwork, &c_b1, &C(1,1), ldc);
		}

/*              W := W * V2' */

		ctrmm_("Right", "Upper", "Conjugate transpose", "Unit", n, k, 
			&c_b1, &V(*m-*k+1,1), ldv, &WORK(1,1), ldwork);

/*              C2 := C2 - W' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *n;
		    for (i = 1; i <= *n; ++i) {
			i__3 = *m - *k + j + i * c_dim1;
			i__4 = *m - *k + j + i * c_dim1;
			r_cnjg(&q__2, &WORK(i,j));
			q__1.r = C(*m-*k+j,i).r - q__2.r, q__1.i = C(*m-*k+j,i).i - 
				q__2.i;
			C(*m-*k+j,i).r = q__1.r, C(*m-*k+j,i).i = q__1.i;
/* L80: */
		    }
/* L90: */
		}

	    } else if (lsame_(side, "R")) {

/*              Form  C * H  or  C * H'  where  C = ( C1  C2 )
   

                W := C * V  =  (C1*V1 + C2*V2)  (stored in WOR
K)   

                W := C2 */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(m, &C(1,*n-*k+j), &c__1, &WORK(1,j), &c__1);
/* L100: */
		}

/*              W := W * V2 */

		ctrmm_("Right", "Upper", "No transpose", "Unit", m, k, &c_b1, 
			&V(*n-*k+1,1), ldv, &WORK(1,1), 
			ldwork);
		if (*n > *k) {

/*                 W := W + C1 * V1 */

		    i__1 = *n - *k;
		    cgemm_("No transpose", "No transpose", m, k, &i__1, &c_b1,
			     &C(1,1), ldc, &V(1,1), ldv, &c_b1, &
			    WORK(1,1), ldwork);
		}

/*              W := W * T  or  W * T' */

		ctrmm_("Right", "Lower", trans, "Non-unit", m, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - W * V' */

		if (*n > *k) {

/*                 C1 := C1 - W * V1' */

		    i__1 = *n - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("No transpose", "Conjugate transpose", m, &i__1, k,
			     &q__1, &WORK(1,1), ldwork, &V(1,1), 
			    ldv, &c_b1, &C(1,1), ldc);
		}

/*              W := W * V2' */

		ctrmm_("Right", "Upper", "Conjugate transpose", "Unit", m, k, 
			&c_b1, &V(*n-*k+1,1), ldv, &WORK(1,1), ldwork);

/*              C2 := C2 - W */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *m;
		    for (i = 1; i <= *m; ++i) {
			i__3 = i + (*n - *k + j) * c_dim1;
			i__4 = i + (*n - *k + j) * c_dim1;
			i__5 = i + j * work_dim1;
			q__1.r = C(i,*n-*k+j).r - WORK(i,j).r, q__1.i = C(i,*n-*k+j).i 
				- WORK(i,j).i;
			C(i,*n-*k+j).r = q__1.r, C(i,*n-*k+j).i = q__1.i;
/* L110: */
		    }
/* L120: */
		}
	    }
	}

    } else if (lsame_(storev, "R")) {

	if (lsame_(direct, "F")) {

/*           Let  V =  ( V1  V2 )    (V1: first K columns)   
             where  V1  is unit upper triangular. */

	    if (lsame_(side, "L")) {

/*              Form  H * C  or  H' * C  where  C = ( C1 )   
                                                    ( C2 )   

                W := C' * V'  =  (C1'*V1' + C2'*V2') (stored i
n WORK)   

                W := C1' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(n, &C(j,1), ldc, &WORK(1,j), &
			    c__1);
		    clacgv_(n, &WORK(1,j), &c__1);
/* L130: */
		}

/*              W := W * V1' */

		ctrmm_("Right", "Upper", "Conjugate transpose", "Unit", n, k, 
			&c_b1, &V(1,1), ldv, &WORK(1,1), ldwork);
		if (*m > *k) {

/*                 W := W + C2'*V2' */

		    i__1 = *m - *k;
		    cgemm_("Conjugate transpose", "Conjugate transpose", n, k,
			     &i__1, &c_b1, &C(*k+1,1), ldc, &V(1,*k+1), ldv, &c_b1, &WORK(1,1), 
			    ldwork);
		}

/*              W := W * T'  or  W * T */

		ctrmm_("Right", "Upper", transt, "Non-unit", n, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - V' * W' */

		if (*m > *k) {

/*                 C2 := C2 - V2' * W' */

		    i__1 = *m - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("Conjugate transpose", "Conjugate transpose", &
			    i__1, n, k, &q__1, &V(1,*k+1), ldv,
			     &WORK(1,1), ldwork, &c_b1, &C(*k+1,1), ldc);
		}

/*              W := W * V1 */

		ctrmm_("Right", "Upper", "No transpose", "Unit", n, k, &c_b1, 
			&V(1,1), ldv, &WORK(1,1), ldwork);

/*              C1 := C1 - W' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *n;
		    for (i = 1; i <= *n; ++i) {
			i__3 = j + i * c_dim1;
			i__4 = j + i * c_dim1;
			r_cnjg(&q__2, &WORK(i,j));
			q__1.r = C(j,i).r - q__2.r, q__1.i = C(j,i).i - 
				q__2.i;
			C(j,i).r = q__1.r, C(j,i).i = q__1.i;
/* L140: */
		    }
/* L150: */
		}

	    } else if (lsame_(side, "R")) {

/*              Form  C * H  or  C * H'  where  C = ( C1  C2 )
   

                W := C * V'  =  (C1*V1' + C2*V2')  (stored in 
WORK)   

                W := C1 */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(m, &C(1,j), &c__1, &WORK(1,j), &c__1);
/* L160: */
		}

/*              W := W * V1' */

		ctrmm_("Right", "Upper", "Conjugate transpose", "Unit", m, k, 
			&c_b1, &V(1,1), ldv, &WORK(1,1), ldwork);
		if (*n > *k) {

/*                 W := W + C2 * V2' */

		    i__1 = *n - *k;
		    cgemm_("No transpose", "Conjugate transpose", m, k, &i__1,
			     &c_b1, &C(1,*k+1), ldc, &V(1,*k+1), ldv, &c_b1, &WORK(1,1), 
			    ldwork);
		}

/*              W := W * T  or  W * T' */

		ctrmm_("Right", "Upper", trans, "Non-unit", m, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - W * V */

		if (*n > *k) {

/*                 C2 := C2 - W * V2 */

		    i__1 = *n - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("No transpose", "No transpose", m, &i__1, k, &q__1,
			     &WORK(1,1), ldwork, &V(1,*k+1), ldv, &c_b1, &C(1,*k+1), ldc);
		}

/*              W := W * V1 */

		ctrmm_("Right", "Upper", "No transpose", "Unit", m, k, &c_b1, 
			&V(1,1), ldv, &WORK(1,1), ldwork);

/*              C1 := C1 - W */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *m;
		    for (i = 1; i <= *m; ++i) {
			i__3 = i + j * c_dim1;
			i__4 = i + j * c_dim1;
			i__5 = i + j * work_dim1;
			q__1.r = C(i,j).r - WORK(i,j).r, q__1.i = C(i,j).i 
				- WORK(i,j).i;
			C(i,j).r = q__1.r, C(i,j).i = q__1.i;
/* L170: */
		    }
/* L180: */
		}

	    }

	} else {

/*           Let  V =  ( V1  V2 )    (V2: last K columns)   
             where  V2  is unit lower triangular. */

	    if (lsame_(side, "L")) {

/*              Form  H * C  or  H' * C  where  C = ( C1 )   
                                                    ( C2 )   

                W := C' * V'  =  (C1'*V1' + C2'*V2') (stored i
n WORK)   

                W := C2' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(n, &C(*m-*k+j,1), ldc, &WORK(1,j), &c__1);
		    clacgv_(n, &WORK(1,j), &c__1);
/* L190: */
		}

/*              W := W * V2' */

		ctrmm_("Right", "Lower", "Conjugate transpose", "Unit", n, k, 
			&c_b1, &V(1,*m-*k+1), ldv, &WORK(1,1), ldwork);
		if (*m > *k) {

/*                 W := W + C1'*V1' */

		    i__1 = *m - *k;
		    cgemm_("Conjugate transpose", "Conjugate transpose", n, k,
			     &i__1, &c_b1, &C(1,1), ldc, &V(1,1), 
			    ldv, &c_b1, &WORK(1,1), ldwork);
		}

/*              W := W * T'  or  W * T */

		ctrmm_("Right", "Lower", transt, "Non-unit", n, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - V' * W' */

		if (*m > *k) {

/*                 C1 := C1 - V1' * W' */

		    i__1 = *m - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("Conjugate transpose", "Conjugate transpose", &
			    i__1, n, k, &q__1, &V(1,1), ldv, &WORK(1,1), ldwork, &c_b1, &C(1,1), ldc);
		}

/*              W := W * V2 */

		ctrmm_("Right", "Lower", "No transpose", "Unit", n, k, &c_b1, 
			&V(1,*m-*k+1), ldv, &WORK(1,1), ldwork);

/*              C2 := C2 - W' */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *n;
		    for (i = 1; i <= *n; ++i) {
			i__3 = *m - *k + j + i * c_dim1;
			i__4 = *m - *k + j + i * c_dim1;
			r_cnjg(&q__2, &WORK(i,j));
			q__1.r = C(*m-*k+j,i).r - q__2.r, q__1.i = C(*m-*k+j,i).i - 
				q__2.i;
			C(*m-*k+j,i).r = q__1.r, C(*m-*k+j,i).i = q__1.i;
/* L200: */
		    }
/* L210: */
		}

	    } else if (lsame_(side, "R")) {

/*              Form  C * H  or  C * H'  where  C = ( C1  C2 )
   

                W := C * V'  =  (C1*V1' + C2*V2')  (stored in 
WORK)   

                W := C2 */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    ccopy_(m, &C(1,*n-*k+j), &c__1, &WORK(1,j), &c__1);
/* L220: */
		}

/*              W := W * V2' */

		ctrmm_("Right", "Lower", "Conjugate transpose", "Unit", m, k, 
			&c_b1, &V(1,*n-*k+1), ldv, &WORK(1,1), ldwork);
		if (*n > *k) {

/*                 W := W + C1 * V1' */

		    i__1 = *n - *k;
		    cgemm_("No transpose", "Conjugate transpose", m, k, &i__1,
			     &c_b1, &C(1,1), ldc, &V(1,1), ldv, &
			    c_b1, &WORK(1,1), ldwork);
		}

/*              W := W * T  or  W * T' */

		ctrmm_("Right", "Lower", trans, "Non-unit", m, k, &c_b1, &T(1,1), ldt, &WORK(1,1), ldwork);

/*              C := C - W * V */

		if (*n > *k) {

/*                 C1 := C1 - W * V1 */

		    i__1 = *n - *k;
		    q__1.r = -1.f, q__1.i = 0.f;
		    cgemm_("No transpose", "No transpose", m, &i__1, k, &q__1,
			     &WORK(1,1), ldwork, &V(1,1), ldv, &
			    c_b1, &C(1,1), ldc);
		}

/*              W := W * V2 */

		ctrmm_("Right", "Lower", "No transpose", "Unit", m, k, &c_b1, 
			&V(1,*n-*k+1), ldv, &WORK(1,1), ldwork);

/*              C1 := C1 - W */

		i__1 = *k;
		for (j = 1; j <= *k; ++j) {
		    i__2 = *m;
		    for (i = 1; i <= *m; ++i) {
			i__3 = i + (*n - *k + j) * c_dim1;
			i__4 = i + (*n - *k + j) * c_dim1;
			i__5 = i + j * work_dim1;
			q__1.r = C(i,*n-*k+j).r - WORK(i,j).r, q__1.i = C(i,*n-*k+j).i 
				- WORK(i,j).i;
			C(i,*n-*k+j).r = q__1.r, C(i,*n-*k+j).i = q__1.i;
/* L230: */
		    }
/* L240: */
		}

	    }

	}
    }

    return 0;

/*     End of CLARFB */

} /* clarfb_ */

